/*
 
  NixieJJT_long_fast
  version 1.1
  
  Written by Jeremy
  Feb 20,2010
  
  Large number counter for OGI Lumen NixieDuos
 
*/

// include the library (Using Lionel Haims's OGI Lumen Nixie lib)
#include <NixieBeta4.h>

// note the digital pins of the arduino that are connected to the nixie driver
#define dataPin 2 // data line or SER
#define clockPin 3 // clock pin or SCK
#define latchPin 4 // latch pin or RCK

// note the number of digits (nixie tubes) you hove (buy more, you need more)
#define numDigits 6 

// just some defines to simplify the examples
#define shortDelay 10
#define longDelay 5000
#define maxCount 999999

// Create the Nixie object
// pass in the pin numbers in the correct order

Nixie nixie(dataPin, clockPin, latchPin);

void setup()

{
  // Clear the display if you wish
  nixie.clear(numDigits);
}
 

void loop()
{
  //just some local variables to help the example
  long i = 0;
  long highestNum = pow(10,numDigits)-1;
  
  // limit the counter just to make sure we don't have to sit and watch it all
  if(highestNum > maxCount) 
  {
    highestNum = maxCount;
  }
 
  // Write out the number using a zero padding.
  // The number will be right justified with "0"s on the left
  // if if the number doesn't use all tubes.
  for(i=0; i <= highestNum; i++)
  {
    // Write the number
      nixie.writeLongNumZero( i, numDigits);
      delay(shortDelay);
  }

  //if wait for the next example
  delay(longDelay); 
}
